<?php

/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

// Ensure visibility.
if (empty($product) || false === wc_get_loop_product_visibility($product->get_id()) || !$product->is_visible()) {
	return;
}
?>
<div class="col_33 <?php wc_product_class('', $product); ?>">
	<div class="item">
		<a href="<?php echo $product->get_permalink() ?>" class="image_shop">
			<?php echo wp_get_attachment_image($product->get_image_id(), 'full') ?>
		</a>
		<div class="content">
			<a href="<?php echo $product->get_permalink() ?>" class="title"><?php do_action('woocommerce_shop_loop_item_title'); ?></a>
			<div class="price_bottom">
				<div class="price"><?php echo wc_price($product->get_price()); //$product->get_price_html(); ?></div>
				<?php do_action('woocommerce_after_shop_loop_item') ?>
			</div>
		</div>
	</div>
</div>